/*
    4D (the "Software") and the corresponding source code remain
    the exclusive property of 4D and/or its licensors and are protected by national
    and/or international legislations.
    This file is part of the source code of the Software provided under the relevant
    4D License Agreement available on http://www.4D.com/license whose compliance
    constitutes a prerequisite to any use of this file and more generally of the
    Software and the corresponding source code.
 */	

waMessage('init');

try {
	document.getElementById("menu_title_0").addEventListener("click", clickMenuTitle);
}
catch(err) {}

document.getElementById("menu_title_1").addEventListener("click", clickMenuTitle);

document.getElementById("noMore").addEventListener("click",
	function() {
		 waMessage('NoMore?' + document.getElementById("noMore").checked);
});

document.getElementById("store").addEventListener("click",
	function() {
		waMessage('openStore');
});

document.getElementById("banner").addEventListener("click",
	function() {
		waMessage('news');
});

document.getElementById("log").addEventListener("click", sign);

var x;
x = document.getElementsByClassName("menu_item_0")
for (i = 0; i < x.length; i++) {
	x[i].addEventListener("click", clickMenuItem);
}

x = document.getElementsByClassName("menu_item_1")
for (i = 0; i < x.length; i++) {
	x[i].addEventListener("click", clickMenuItem);
}

try {
	if(document.getElementById("recent_databases").childElementCount > 0) {
		openMenu('menu_title_0');
	}
}
catch(err) {
	openMenu('menu_title_1');	
}

function setUser(user) {
	document.d4user = user;
	document.getElementById("welcome").innerHTML = user.message;
	document.getElementById("log").innerHTML = user.log;
	if (user.firstName != undefined) {
		 document.getElementById("log").setAttribute("class", "signout");
	} else {
		 document.getElementById("log").setAttribute("class", "signin");	
	}
}

function sign() {
	var user = document.d4user;
	if (user == undefined) {
		user = {};
	}
	waMessage('user?' + JSON.stringify(user));
}

function clickMenuTitle() {
	openMenu(this.id);	
}

function openMenu(menu) {
	var me, item;
	switch (menu) {
	case 'menu_title_0':
		me = document.getElementById("menu_title_0");
		me.setAttribute("class", "opened");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'inherit';
		}
		me = document.getElementById("menu_title_1");
		me.setAttribute("class", "closed");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'none';
		}
		break;
		
	case 'menu_title_1':
		me = document.getElementById("menu_title_0");
		if (me != null) {
			me.setAttribute("class", "closed");
			item = me.parentElement.children;
			for (i = 1; i < item.length; i++) {
				item[i].style.display = 'none';
			}
		}
		me = document.getElementById("menu_title_1");
		me.setAttribute("class", "opened");
		item = me.parentElement.children;
		for (i = 1; i < item.length; i++) {
			item[i].style.display = 'inherit';
		}
		break;
	}
}

function clickMenuItem() {		
	switch (this.id) {
		case '1_1':
			waMessage('connectTo4dServer');
			break;
		case '1_2':
			waMessage('openALocalApplication');
			break;
		case '1_3':
			waMessage('createANewApplication');	
			break;
		default:
			waMessage('4dlink_'+this.getAttribute("path"));
	}
}
